using System;
using System.Data;
using System.Collections.Generic;
using System.Text;

namespace CodeAttributeDemo
{
[AttributeUsage(AttributeTargets.Class)]
class DataTableAttribute : Attribute
{
private string tableName = "Tabela";
private System.Data.DbType dataType = DbType.String;

public DataTableAttribute(string table)
{
	tableName = table;
	dataType = DbType.String;
}

public DataTableAttribute(string table, DbType dbtype)
{
   tableName = table;
   dataType = dbtype;
}

public string TableName
{
   get { return  tableName; }
   set { tableName = value; }
}

public DbType DataType
{
   get { return dataType; }
   set { dataType = value; }
}
}
}
